load('Figure4S2AB_Data.mat')

%% Group by treatment
% Each time frame is 15min, calculate time from 2h before G1/S to 2h after G1/S
treatments = ["DMSO";"Rapamycin, 5nM"]; 
NN = length(treatments); stat = struct; stat.data = cell(NN, 1);
for plate = 1:2
    for nn = 1:NN
        idx = strcmp(tracks.treatments,treatments{nn})&tracks.Plate==plate;
        temp = cat(1,tracks.FullTracks{idx});
        temp = temp(:,{'EG1Tt', 'mArea', 'Feat', 'GrowthRate'});
        temp.Plate = ones(size(temp,1),1)*plate;
        stat.data{nn} = [stat.data{nn}; temp];
    end
end
clear temp idx nn plate        
% normalize size & gr among the two plates
temp0 = mean(stat.data{1}.mArea);
for plate = 1:2
    temp = mean(stat.data{1}.mArea(stat.data{1}.Plate==plate))/temp0; %temp = 1; %
    for nn = 1:NN
        idx = find(stat.data{nn}.Plate==plate);
        stat.data{nn}.mArea(idx) = stat.data{nn}.mArea(idx)/temp;
        Nc = length(idx);
        for nc = 1:Nc
            stat.data{nn}.GrowthRate{idx(nc)}(:,2) = stat.data{nn}.GrowthRate{idx(nc)}(:,2)*4/temp; %*4 to change the unit of growth rate from /frame to /hr
            stat.data{nn}.Feat{nc}.Area = stat.data{nn}.Feat{nc}.Area/temp;
        end
    end
end
clear nn nc temp temp0 Nc nc idx plate

%% Calculate by treatment
stat.Tt = (-10:2)'; Nt = length(stat.Tt);
stat.corrs = nan(Nt, NN); stat.corrsCI = nan(Nt, NN);
for nn = 1:NN
    Nc = size(stat.data{nn},1);
    stat.data{nn}.gr = nan(Nc,Nt);
    stat.data{nn}.size = nan(Nc,Nt);
end
for nt = 1:Nt
    tt = stat.Tt(nt);
    for nn = 1:NN
        Nc = size(stat.data{nn},1);
        for nc = 1:Nc
            temp = stat.data{nn}.GrowthRate{nc};
            if any(ismember(temp(:,1),round(stat.data{nn}.EG1Tt(nc)+tt)))
                stat.data{nn}.gr(nc,nt) = temp(temp(:,1)==round(stat.data{nn}.EG1Tt(nc)+tt), 2);
                stat.data{nn}.gr(nc,nt) = temp(temp(:,1)==round(stat.data{nn}.EG1Tt(nc)+tt), 2);
            end
            temp1 = stat.data{nn}.Feat{nc}{:,{'Ti', 'Area'}}; temp1(:,1) = temp1(:,1)-temp1(1,1);
            if any(ismember(temp1(:,1),round(stat.data{nn}.EG1Tt(nc)+tt)))
                stat.data{nn}.size(nc,nt) = temp1(temp1(:,1)==round(stat.data{nn}.EG1Tt(nc)+tt), 2);
                stat.data{nn}.size(nc,nt) = temp1(temp1(:,1)==round(stat.data{nn}.EG1Tt(nc)+tt), 2);
            end
        end
        idx = ~(isnan(stat.data{nn}.mArea)|isnan(stat.data{nn}.gr(:,nt)));
        fitobj = fit(stat.data{nn}.mArea(idx), stat.data{nn}.gr(idx,nt), 'poly1', 'Robust','Bisquare');
        fitCI = confint(fitobj, .9);
        stat.corrs(nt, nn) = fitobj.p1;
        stat.corrsCI(nt, nn) = fitobj.p1-fitCI(1,1);
    end
end
% % compare slopes
% figure;  colors = [0 0 0; 0 .6 0];
% for nn = 1:NN
%     plot(stat.Tt, stat.corrs(:,nn), '-', 'color', colors(nn,:),'LineWidth',1,'handleVisibility', 'off'); hold on; 
%     fill([stat.Tt; stat.Tt(end:-1:1)], [stat.corrs(:,nn)+stat.corrsCI(:,nn); stat.corrs(end:-1:1,nn)-stat.corrsCI(end:-1:1,nn)], colors(nn,:),'FaceAlpha',.3, 'EdgeColor','none')
% end
% legend(treatments, 'Location','northwest')
% xlim(stat.Tt([1 end])); xticks(stat.Tt(1:2:end)); xticklabels(stat.Tt(1:2:end)/4); ylim([0 .12]);
% xlabel('time/hr (from G1/S transition)'); ylabel('slope(m, v)'); grid on
% % scatterplot
% Tt = [-5 2]; colors = [1 .5 .2; .2 .6 1];
% for nn = 1:NN
%     figure (30+nn); 
%     for nt = 1:length(Tt)
%         scatter(stat.data{nn}.mArea, stat.data{nn}.gr(:,stat.Tt==Tt(nt)), 10, colors(nt,:), 'filled', 'MarkerFaceAlpha',.3, 'MarkerEdgeColor','none'); hold on;
%     end
%     for nt = 1:length(Tt)
%         idx = ~(isnan(stat.data{nn}.mArea)|isnan(stat.data{nn}.gr(:,stat.Tt==Tt(nt))));
%         fitobj = fit(stat.data{nn}.mArea(idx), stat.data{nn}.gr(idx,stat.Tt==Tt(nt)), 'poly1', 'Robust','Bisquare');
%         plot([min(stat.data{nn}.mArea) max(stat.data{nn}.mArea)], [min(stat.data{nn}.mArea) max(stat.data{nn}.mArea)]*fitobj.p1+fitobj.p2,...
%             '-','Color',colors(nt,:)*.8, 'HandleVisibility','off');
%     end
%     title(treatments{nn}); xlabel('cell size (pix.)'); ylabel('growth rate (pix./hr)');
%     xlim([400 1400]); ylim([-100 150]); ylim([5 47]);
%     legend({['t = ' num2str(Tt(1)/4, '%.2f') ' hr'], ['t = ' num2str(Tt(2)/4, '%.2f') ' hr']}, 'Location','northwest')
% end

clear nn nc nt fitCI fitobj idx temp tempDMSO plate Nt Tt Nc color colors

%% barplot comparing average growth rate of small vs large cells
Tt = [-5 2]; Nt = length(Tt); prct = 100/3;
avgGr = cell(NN, 1); avgGrCI = cell(NN,1); grsm = cell(NN,tt); grlg = cell(NN,tt);
for nn = 1:NN
    avgGr{nn} = nan(Nt, 3); avgGrCI{nn} = nan(Nt, 3);
    for nt = 1:Nt
        % all cells
        temp = stat.data{nn}.gr(:,stat.Tt==Tt(nt));
        avgGr{nn}(nt, 1) = nanmean(temp);
        avgGrCI{nn}(nt, 1) = bsxfun(@times, nanstd(temp)/sqrt(size(temp,1)), tinv(0.975,size(temp,1)-1)); % 0.9 ci
        % 1/3 large
        idx = stat.data{nn}.mArea>=prctile(stat.data{nn}.mArea,100-prct);
        avgGr{nn}(nt, 3) = nanmean(temp(idx,:))';
        avgGrCI{nn}(nt,3) = bsxfun(@times, nanstd(temp(idx))'/sqrt(sum(idx)), tinv(0.95,sum(idx)-1)); % 0.9 ci
        grsm{nn,nt} = temp(idx,:);
        % 1/3 smallest
        idx = stat.data{nn}.mArea<=prctile(stat.data{nn}.mArea,prct);
        avgGr{nn}(nt, 2) = nanmean(temp(idx,:))';
        avgGrCI{nn}(nt,2) = bsxfun(@times, nanstd(temp(idx))'/sqrt(sum(idx)), tinv(0.95,sum(idx)-1)); % 0.9 ci
        grlg{nn,nt} = temp(idx,:);
    end
end
avgGr = [avgGr{1}; avgGr{2}]; avgGrCI = [avgGrCI{1}; avgGrCI{2}];
Nv=2;
figure;bar(1:4,avgGr(:,2:3));hold on;
groupwidth = min(0.8, Nv/(Nv + 1.5));
for nv = 1:2
    xx = (1:4) - groupwidth/2 + (2*nv-1) * groupwidth / (2*Nv);
    errorbar(xx, avgGr(:,nv+1), avgGrCI(:,nv+1),'.', 'Marker','none', 'Color','k','LineWidth',1);       
%     scatter(xx(1)+randn(length(grsm{nv,1}),1)*0.03, grsm{nv,1},3,[1 1 1]*.5,'filled','markerfacealpha',.15)
%     scatter(xx(2)+randn(length(grlg{nv,1}),1)*0.03, grlg{nv,1},3,[1 1 1]*.5,'filled','markerfacealpha',.15)
%     scatter(xx(3)+randn(length(grsm{nv,2}),1)*0.03, grsm{nv,2},3,[1 1 1]*.5,'filled','markerfacealpha',.15)
%     scatter(xx(4)+randn(length(grlg{nv,2}),1)*0.03, grlg{nv,2},3,[1 1 1]*.5,'filled','markerfacealpha',.15)
end
set(gca,'xtick',1:4,'xticklabel',{'-1.25h', '1h', '-1.25h', '1h'},'fontsize',13); ylabel('Growth Rate (pix./hr)');
legend('small cells','large cells','location','northeast'); %ylim([-50 100])

%% plot avg growth rate for whole cc
for kk=1:size(stat.data,1)
    for tt=1:size(stat.data{kk,1})
        stat.data{kk,1}.AvgGR(tt)=nanmedian(stat.data{kk,1}.GrowthRate{tt,1}(:,2));
    end
end

dmsoGR=stat.data{1,1}.AvgGR; rapGR=stat.data{2,1}.AvgGR;
% dmsoGRCI=bsxfun(@times, nanstd(dmsoGR)/sqrt(length(dmsoGR)), tinv(0.95,length(dmsoGR)-1));
% rapGRCI=bsxfun(@times, nanstd(rapGR)/sqrt(length(rapGR)), tinv(0.95,length(rapGR)-1));
dmsoGRsma=dmsoGR(stat.data{1,1}.mArea<prctile(stat.data{1,1}.mArea,100/3));
dmsoGRbig=dmsoGR(stat.data{1,1}.mArea>prctile(stat.data{1,1}.mArea,100-(100/3)));
rapGRsma=rapGR(stat.data{2,1}.mArea<prctile(stat.data{2,1}.mArea,100/3));
rapGRbig=rapGR(stat.data{2,1}.mArea>prctile(stat.data{2,1}.mArea,100-(100/3)));

dmsoGRsmaCI=bsxfun(@times, nanstd(dmsoGRsma)/sqrt(length(dmsoGRsma)), tinv(0.95,length(dmsoGRsma)-1));
dmsoGRbigCI=bsxfun(@times, nanstd(dmsoGRbig)/sqrt(length(dmsoGRbig)), tinv(0.95,length(dmsoGRbig)-1));
rapGRsmaCI=bsxfun(@times, nanstd(rapGRsma)/sqrt(length(rapGRsma)), tinv(0.95,length(rapGRsma)-1));
rapGRbigCI=bsxfun(@times, nanstd(rapGRbig)/sqrt(length(rapGRbig)), tinv(0.95,length(rapGRbig)-1));

figure; b=bar([nanmedian(dmsoGRsma) nanmedian(dmsoGRbig);nanmedian(rapGRsma) nanmedian(rapGRbig)]); hold on;
errorbar([0.8571 1.1429; 1.8571 2.1429],[nanmedian(dmsoGRsma) nanmedian(dmsoGRbig);nanmedian(rapGRsma) nanmedian(rapGRbig)],...
    [(dmsoGRsmaCI) (dmsoGRbigCI);(rapGRsmaCI) (rapGRbigCI)],'color','k','linestyle','none')
%     scatter(0.8571+randn(length(dmsoGRsma),1)*0.03, dmsoGRsma,3,[1 1 1]*.5,'filled','markerfacealpha',.15)
%     scatter(1.1429+randn(length(dmsoGRbig),1)*0.03, dmsoGRbig,3,[1 1 1]*.5,'filled','markerfacealpha',.15)
%     scatter(1.8571+randn(length(rapGRsma),1)*0.03, rapGRsma,3,[1 1 1]*.5,'filled','markerfacealpha',.15)
%     scatter(2.1429+randn(length(rapGRbig),1)*0.03, rapGRbig,3,[1 1 1]*.5,'filled','markerfacealpha',.15)
set(gca,'xtick',1:2,'xticklabel',{'Ctrl','mTORi'}); set(gca,'fontsize',13,'ytick',0:10:35); ylabel('Growth Rate (pix./hr)'); ylim([0 35])
xtickangle(45);

%% plot AHA
load('Figure4S2C_Data.mat'); 

chAHA=1; chSE=2;
ResultTable.CInt(:,chAHA) = ResultTable.CInt(:,chAHA)/median(ResultTable.CInt(ResultTable.condition=="DMSO",chAHA));
ctrl=ResultTable(ResultTable.condition=="DMSO",:);tor=ResultTable(ResultTable.condition=="Torin",:);
dmsoAHAsma=ctrl.CInt(ctrl.CInt(:,chSE)<prctile(ctrl.CInt(:,chSE),100/3),chAHA);
dmsoAHAbig=ctrl.CInt(ctrl.CInt(:,chSE)>prctile(ctrl.CInt(:,chSE),100-100/3),chAHA);
torAHAsma=tor.CInt(tor.CInt(:,chSE)<prctile(tor.CInt(:,chSE),100/3),chAHA);
torAHAbig=tor.CInt(tor.CInt(:,chSE)>prctile(tor.CInt(:,chSE),100-100/3),chAHA);


dmsoAHAsmaCI=bsxfun(@times, nanstd(dmsoAHAsma)/sqrt(length(dmsoAHAsma)), tinv(0.95,length(dmsoAHAsma)-1));
dmsoAHAbigCI=bsxfun(@times, nanstd(dmsoAHAbig)/sqrt(length(dmsoAHAbig)), tinv(0.95,length(dmsoAHAbig)-1));
torAHAsmaCI=bsxfun(@times, nanstd(torAHAsma)/sqrt(length(torAHAsma)), tinv(0.95,length(torAHAsma)-1));
torAHAbigCI=bsxfun(@times, nanstd(torAHAbig)/sqrt(length(torAHAbig)), tinv(0.95,length(torAHAbig)-1));

% plotting
figure; b=bar([nanmedian(dmsoAHAsma) nanmedian(dmsoAHAbig);nanmedian(torAHAsma) nanmedian(torAHAbig)]); hold on;
errorbar([0.8571 1.1429; 1.8571 2.1429],[nanmedian(dmsoAHAsma) nanmedian(dmsoAHAbig);nanmedian(torAHAsma) nanmedian(torAHAbig)],...
    [(dmsoAHAsmaCI) (dmsoAHAbigCI);(torAHAsmaCI) (torAHAbigCI)],'color','k','linestyle','none')
%     scatter(0.8571+randn(length(dmsoAHAsma),1)*0.03, dmsoAHAsma,3,[1 1 1]*.5,'filled','markerfacealpha',.15)
%     scatter(1.1429+randn(length(dmsoAHAbig),1)*0.03, dmsoAHAbig,3,[1 1 1]*.5,'filled','markerfacealpha',.15)
%     scatter(1.8571+randn(length(torAHAsma),1)*0.03, torAHAsma,3,[1 1 1]*.5,'filled','markerfacealpha',.15)
%     scatter(2.1429+randn(length(torAHAbig),1)*0.03, torAHAbig,3,[1 1 1]*.5,'filled','markerfacealpha',.15)
set(gca,'xtick',1:2,'xticklabel',{'Ctrl','mTORi'}); set(gca,'fontsize',13,'ytick',0:.5:1.5); ylabel('AHA incorporation(a.u.)'); 
ylim([0 1.5]); xtickangle(45);


